<?php
require_once('lib/nusoap.php'); 

$server = new nusoap_server;

$server->configureWSDL('wsQvet', 'urn:server');

$server->wsdl->schemaTargetNamespace = 'urn:server';

//SOAP complex type return type (an array/struct)
$server->wsdl->addComplexType(
    'Person',
    'complexType',
    'struct',
    'all',
    '',
    array('Resp' => array('name' => 'Validacion', 'type' => 'xsd:string'),
          'DetalleOperacion' => array('name' => 'DetalleOperacion', 'type' => 'xsd:string'))
);

//this is the test webservice entry point/function 
$server->register('wsQvet',
			array('username' => 'xsd:string', 'password'=>'xsd:string', 'process'=>'xsd:string', 'xmlProcess'=>'xsd:string'),  //parameters
			array('return' => 'tns:Person'),  //output
			'urn:server',   //namespace
			'urn:server#wsQvet',  //soapaction
			'rpc', // style
			'encoded', // use
			'Web Service Integracion QVET G-ERP');  //description

function wsQvet($username, $password, $process, $xmlProcess)
{
	$arr = array('Resp'=> 'int','DetalleOperacion'=> 'string');
		
	$file = fopen("archivo.txt", "w");
	fwrite($file, $username . PHP_EOL);
	fwrite($file, $password . PHP_EOL);
	fwrite($file, $xmlProcess . PHP_EOL);
	fclose($file);

	return $arr;
}

$HTTP_RAW_POST_DATA = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : '';
$server->service($HTTP_RAW_POST_DATA);
?>