# HeidiSQL Dump 
#
# --------------------------------------------------------
# Host:                 127.0.0.1
# Database:             erp
# Server version:       5.0.16-nt
# Server OS:            Win32
# Target-Compatibility: MySQL 4.0
# Extended INSERTs:     Y
# max_allowed_packet:   1048576
# HeidiSQL version:     3.0 Revision: 572
# --------------------------------------------------------

/*!40100 SET CHARACTER SET latin1*/;


#
# Database structure for database 'erp'
#

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `erp` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `erp`;


#
# Table structure for table 'la_aprob_cont_cal'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_aprob_cont_cal` (
  `COD_MP` varchar(10) NOT NULL,
  `COD_PROD` varchar(10) NOT NULL,
  `cantidad` bigint(11) NOT NULL,
  `lote` varchar(10) NOT NULL,
  `fech_ultm` date NOT NULL,
  `hab_bloq` varchar(15) NOT NULL,
  `INDICADOR` varchar(15) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_aprob_cont_cal'
#

/*!40000 ALTER TABLE `la_aprob_cont_cal` DISABLE KEYS*/;
LOCK TABLES `la_aprob_cont_cal` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_aprob_cont_cal` ENABLE KEYS*/;


#
# Table structure for table 'la_areas'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_areas` (
  `id_area` bigint(5) NOT NULL auto_increment,
  `descripcion_area` varchar(50) default NULL,
  `fecha_area` date NOT NULL default '0000-00-00',
  `hora_area` time NOT NULL default '00:00:00',
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id_area`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_areas'
#

/*!40000 ALTER TABLE `la_areas` DISABLE KEYS*/;
LOCK TABLES `la_areas` WRITE;
REPLACE INTO `la_areas` (`id_area`, `descripcion_area`, `fecha_area`, `hora_area`, `USER`, `FECHA_U`, `HORA`) VALUES ('1','FINANZAS','0000-00-00','00:00:00','administrador','2006-12-04','07:58:55'),
	('2','contabilidad','2008-09-03','21:21:21','administrador','2006-12-04','07:58:55');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_areas` ENABLE KEYS*/;


#
# Table structure for table 'la_ciudad'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_ciudad` (
  `COD_CIU` int(5) unsigned NOT NULL auto_increment,
  `NOM_CIU` varchar(100) NOT NULL default '',
  `USER` varchar(30) default NULL,
  `FECHA_U` date default NULL,
  `HORA` time default NULL,
  PRIMARY KEY  (`COD_CIU`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_ciudad'
#

/*!40000 ALTER TABLE `la_ciudad` DISABLE KEYS*/;
LOCK TABLES `la_ciudad` WRITE;
REPLACE INTO `la_ciudad` (`COD_CIU`, `NOM_CIU`, `USER`, `FECHA_U`, `HORA`) VALUES (2,'ALHUE',NULL,NULL,NULL),
	(1,'ALGARROBO',NULL,NULL,NULL),
	(3,'ALTO DEL CARMEN',NULL,NULL,NULL),
	(4,'ANCUD',NULL,NULL,NULL),
	(5,'ANDACOLLO',NULL,NULL,NULL),
	(6,'ANGOL',NULL,NULL,NULL),
	(7,'ANTOFAGASTA',NULL,NULL,NULL),
	(8,'ANTUCO',NULL,NULL,NULL),
	(9,'ARAUCO',NULL,NULL,NULL),
	(10,'ARICA',NULL,NULL,NULL),
	(11,'BAQUEDANO',NULL,NULL,NULL),
	(12,'BUIN',NULL,NULL,NULL),
	(13,'BULNES',NULL,NULL,NULL),
	(14,'C. DE VELEZ',NULL,NULL,NULL),
	(15,'C.SOMBRERO',NULL,NULL,NULL),
	(16,'C0NTULMO',NULL,NULL,NULL),
	(17,'CABILDO',NULL,NULL,NULL),
	(18,'CABRERO',NULL,NULL,NULL),
	(19,'CALAMA',NULL,NULL,NULL),
	(20,'CALBUCO',NULL,NULL,NULL),
	(21,'CALDERA',NULL,NULL,NULL),
	(22,'CALERA',NULL,NULL,NULL),
	(23,'CALERA DE TANGO',NULL,NULL,NULL),
	(24,'CALLE LARGA',NULL,NULL,NULL),
	(25,'CAMIA',NULL,NULL,NULL),
	(26,'CANELA BAJA',NULL,NULL,NULL),
	(27,'CAETE',NULL,NULL,NULL),
	(28,'CARAHUE',NULL,NULL,NULL),
	(29,'CARTAGENA',NULL,NULL,NULL),
	(30,'CASABLANCA',NULL,NULL,NULL),
	(31,'CASTRO',NULL,NULL,NULL),
	(32,'CATEMU',NULL,NULL,NULL),
	(33,'CAUQUENES',NULL,NULL,NULL),
	(34,'CHAITEN',NULL,NULL,NULL),
	(35,'CHAARAL',NULL,NULL,NULL),
	(36,'CHANCO',NULL,NULL,NULL),
	(37,'CHEPICA',NULL,NULL,NULL),
	(38,'CHILE CHICO',NULL,NULL,NULL),
	(39,'CHILLAN',NULL,NULL,NULL),
	(40,'CHIMBARONGO',NULL,NULL,NULL),
	(41,'CHONCHI',NULL,NULL,NULL),
	(42,'COBQUECURA',NULL,NULL,NULL),
	(43,'COCHAMO',NULL,NULL,NULL),
	(44,'COCHRANE',NULL,NULL,NULL),
	(45,'CODEGUA',NULL,NULL,NULL),
	(46,'COELEMU',NULL,NULL,NULL),
	(47,'COIHAIQUE',NULL,NULL,NULL),
	(48,'COIHUECO',NULL,NULL,NULL),
	(49,'COINCO',NULL,NULL,NULL),
	(50,'COLBUN',NULL,NULL,NULL),
	(51,'COLCHANE',NULL,NULL,NULL),
	(52,'COLINA',NULL,NULL,NULL),
	(53,'COLLIPULLI',NULL,NULL,NULL),
	(54,'COLTAUCO',NULL,NULL,NULL),
	(55,'COLTAUCO',NULL,NULL,NULL),
	(56,'COMBARBALA',NULL,NULL,NULL),
	(57,'CONCEPCION',NULL,NULL,NULL),
	(58,'CONSTITUCION',NULL,NULL,NULL),
	(59,'COPIAPO',NULL,NULL,NULL),
	(60,'COQUIMBO',NULL,NULL,NULL),
	(61,'CORONEL',NULL,NULL,NULL),
	(62,'CORRAL',NULL,NULL,NULL),
	(63,'CRUZ DEL SUR',NULL,NULL,NULL),
	(64,'CUMPEO',NULL,NULL,NULL),
	(65,'CUNCO',NULL,NULL,NULL),
	(66,'CURACAUTIN',NULL,NULL,NULL),
	(67,'CURACAVI',NULL,NULL,NULL),
	(68,'CURANILAHUE',NULL,NULL,NULL),
	(69,'CURARREHUE',NULL,NULL,NULL),
	(70,'CUREPTO',NULL,NULL,NULL),
	(71,'CURICO',NULL,NULL,NULL),
	(72,'CUYA',NULL,NULL,NULL),
	(73,'D. ALMAGRO',NULL,NULL,NULL),
	(74,'DALCAHUE',NULL,NULL,NULL),
	(75,'DOIHUE',NULL,NULL,NULL),
	(76,'E. LAGOS',NULL,NULL,NULL),
	(77,'EL CARMEN',NULL,NULL,NULL),
	(78,'EL MONTE',NULL,NULL,NULL),
	(79,'EL QUISCO',NULL,NULL,NULL),
	(80,'EL TABO',NULL,NULL,NULL),
	(81,'EMPEDRADO',NULL,NULL,NULL),
	(82,'ERCILLA',NULL,NULL,NULL),
	(83,'FLORIDA',NULL,NULL,NULL),
	(84,'FREIRE',NULL,NULL,NULL),
	(85,'FREIRINA',NULL,NULL,NULL),
	(86,'FRESIA',NULL,NULL,NULL),
	(87,'FRUTILLAR',NULL,NULL,NULL),
	(88,'FUTALEUFU',NULL,NULL,NULL),
	(89,'FUTRONO',NULL,NULL,NULL),
	(90,'GALVARINO',NULL,NULL,NULL),
	(91,'GORBEA',NULL,NULL,NULL),
	(92,'GRANEROS',NULL,NULL,NULL),
	(93,'HIJUELAS',NULL,NULL,NULL),
	(94,'HUALAE',NULL,NULL,NULL),
	(95,'HUALQUI',NULL,NULL,NULL),
	(96,'HUARA',NULL,NULL,NULL),
	(97,'HUASCO',NULL,NULL,NULL),
	(98,'I.DE MAIPO',NULL,NULL,NULL),
	(99,'ILLAPEL',NULL,NULL,NULL),
	(100,'IQUIQUE',NULL,NULL,NULL),
	(101,'JUAN FERNADEZ',NULL,NULL,NULL),
	(102,'LA CRUZ',NULL,NULL,NULL),
	(103,'LA ESTRELLA',NULL,NULL,NULL),
	(104,'LA HIGUERA',NULL,NULL,NULL),
	(105,'LA LIGUA',NULL,NULL,NULL),
	(106,'LA SERENA',NULL,NULL,NULL),
	(107,'LA UNION',NULL,NULL,NULL),
	(108,'LAGO RANCO',NULL,NULL,NULL),
	(109,'LAGO VERDE',NULL,NULL,NULL),
	(110,'LAMPA',NULL,NULL,NULL),
	(111,'LANCO',NULL,NULL,NULL),
	(112,'LAS CABRAS',NULL,NULL,NULL),
	(113,'LAUTARO',NULL,NULL,NULL),
	(114,'LEBU',NULL,NULL,NULL),
	(115,'LICANTEN',NULL,NULL,NULL),
	(116,'LIMACHE',NULL,NULL,NULL),
	(117,'LINARES',NULL,NULL,NULL),
	(118,'LITUECHE',NULL,NULL,NULL),
	(119,'LLANQUIHUE',NULL,NULL,NULL),
	(120,'LLAYLLAY',NULL,NULL,NULL),
	(121,'LOLOL',NULL,NULL,NULL),
	(122,'LONCOCHE',NULL,NULL,NULL),
	(123,'LONGAVI',NULL,NULL,NULL),
	(124,'LONQUIMAY',NULL,NULL,NULL),
	(125,'LOS ALAMOS',NULL,NULL,NULL),
	(126,'LOS ANDES',NULL,NULL,NULL),
	(127,'LOS ANGELES',NULL,NULL,NULL),
	(128,'LOS LAGOS',NULL,NULL,NULL),
	(129,'LOS MUERMOS',NULL,NULL,NULL),
	(130,'LOS SAUCES',NULL,NULL,NULL),
	(131,'LOS VILOS',NULL,NULL,NULL),
	(132,'LOTA',NULL,NULL,NULL),
	(133,'LUMACO',NULL,NULL,NULL),
	(134,'M.ELENA',NULL,NULL,NULL),
	(135,'M.PATRIA',NULL,NULL,NULL),
	(136,'M.PINTO',NULL,NULL,NULL),
	(137,'MACHALI',NULL,NULL,NULL),
	(138,'MAFIL',NULL,NULL,NULL),
	(139,'MALLOA',NULL,NULL,NULL),
	(140,'MARCHIGUE',NULL,NULL,NULL),
	(141,'MAULE',NULL,NULL,NULL),
	(142,'MAULLIN',NULL,NULL,NULL),
	(143,'MEJILLONES',NULL,NULL,NULL),
	(144,'MELINKA',NULL,NULL,NULL),
	(145,'MELIPEUCO',NULL,NULL,NULL),
	(146,'MELIPILLA',NULL,NULL,NULL),
	(147,'MOLINA',NULL,NULL,NULL),
	(148,'MULCHEN',NULL,NULL,NULL),
	(149,'N.IMPERIAL',NULL,NULL,NULL),
	(150,'N.TOLTEN',NULL,NULL,NULL),
	(151,'NACIMIENTO',NULL,NULL,NULL),
	(152,'NANCAGUA',NULL,NULL,NULL),
	(153,'NAVIDAD',NULL,NULL,NULL),
	(154,'NEGRETE',NULL,NULL,NULL),
	(155,'NINHUEIQUEN',NULL,NULL,NULL),
	(156,'NOGALES',NULL,NULL,NULL),
	(157,'OLIVAR',NULL,NULL,NULL),
	(158,'OLLAGUE',NULL,NULL,NULL),
	(159,'OLMUE',NULL,NULL,NULL),
	(160,'OSORNO',NULL,NULL,NULL),
	(161,'OVALLE',NULL,NULL,NULL),
	(162,'P. NATALES',NULL,NULL,NULL),
	(163,'P.ALMONTE',NULL,NULL,NULL),
	(164,'P.DELGADA',NULL,NULL,NULL),
	(165,'P.OCTAY',NULL,NULL,NULL),
	(166,'PAIHUANO',NULL,NULL,NULL),
	(167,'PAILLACO',NULL,NULL,NULL),
	(168,'PAINE',NULL,NULL,NULL),
	(169,'PALENA',NULL,NULL,NULL),
	(170,'PALMILLA',NULL,NULL,NULL),
	(171,'PANGUIPULLI',NULL,NULL,NULL),
	(172,'PANQUEHUE',NULL,NULL,NULL),
	(173,'PAPUDO',NULL,NULL,NULL),
	(174,'PAREDONES',NULL,NULL,NULL),
	(175,'PARRAL',NULL,NULL,NULL),
	(176,'PELARCO',NULL,NULL,NULL),
	(177,'PELLUHUE',NULL,NULL,NULL),
	(178,'PEMUCO',NULL,NULL,NULL),
	(179,'PEAFLOR',NULL,NULL,NULL),
	(180,'PENCAHUE',NULL,NULL,NULL),
	(181,'PENCO',NULL,NULL,NULL),
	(182,'PERALILLO',NULL,NULL,NULL),
	(183,'PERQUENCO',NULL,NULL,NULL),
	(184,'PETORCA',NULL,NULL,NULL),
	(185,'PEUMO',NULL,NULL,NULL),
	(186,'PICA',NULL,NULL,NULL),
	(187,'PICHASCA',NULL,NULL,NULL),
	(188,'PICHILEMU',NULL,NULL,NULL),
	(189,'PINTO',NULL,NULL,NULL),
	(190,'PIRQUE',NULL,NULL,NULL),
	(191,'PITRUFQUEN',NULL,NULL,NULL),
	(192,'PLACILLA',NULL,NULL,NULL),
	(193,'PORTEZUELO',NULL,NULL,NULL),
	(194,'PORVENIR',NULL,NULL,NULL),
	(195,'PTE. ALTO',NULL,NULL,NULL),
	(196,'PTO. AYSEN',NULL,NULL,NULL),
	(197,'PTO. CISNES',NULL,NULL,NULL),
	(198,'PTO. ING.IBAEZ',NULL,NULL,NULL),
	(199,'PTO. MONTT',NULL,NULL,NULL),
	(200,'PTO. VARAS',NULL,NULL,NULL),
	(201,'PTO.SAAVEDRA',NULL,NULL,NULL),
	(202,'PUAUCHO',NULL,NULL,NULL),
	(203,'PUCHUINCAVI',NULL,NULL,NULL),
	(204,'PUCON',NULL,NULL,NULL),
	(205,'PUMANQUE',NULL,NULL,NULL),
	(206,'PUNITAQUI',NULL,NULL,NULL),
	(207,'PUQUELDON',NULL,NULL,NULL),
	(208,'PUREN',NULL,NULL,NULL),
	(209,'PURRANQUE',NULL,NULL,NULL),
	(210,'PUTAENDO',NULL,NULL,NULL),
	(211,'PUTRE',NULL,NULL,NULL),
	(212,'Q.DEL TILCOCO',NULL,NULL,NULL),
	(213,'QUEILEN',NULL,NULL,NULL),
	(214,'QUELLON',NULL,NULL,NULL),
	(215,'QUEMCHI',NULL,NULL,NULL),
	(216,'QUILACO',NULL,NULL,NULL),
	(217,'QUILLECO',NULL,NULL,NULL),
	(218,'QUILLON',NULL,NULL,NULL),
	(219,'QUILLOTA',NULL,NULL,NULL),
	(220,'QUILPUE',NULL,NULL,NULL),
	(221,'QUINCHAO',NULL,NULL,NULL),
	(222,'QUINTERO',NULL,NULL,NULL),
	(223,'QUIRIHUE',NULL,NULL,NULL),
	(224,'RANCAGUA',NULL,NULL,NULL),
	(225,'RANQUIL',NULL,NULL,NULL),
	(226,'RAUCO',NULL,NULL,NULL),
	(227,'RENAICO',NULL,NULL,NULL),
	(228,'RENGO',NULL,NULL,NULL),
	(229,'REQUINOA',NULL,NULL,NULL),
	(230,'RETIRO',NULL,NULL,NULL),
	(231,'RINCONADA',NULL,NULL,NULL),
	(232,'RIO BUENO',NULL,NULL,NULL),
	(233,'RIO NEGRO',NULL,NULL,NULL),
	(234,'ROMERAL',NULL,NULL,NULL),
	(235,'S.J.DE LA MARIQUINA',NULL,NULL,NULL),
	(236,'S.P. ATACAMA',NULL,NULL,NULL),
	(237,'SAGR.FAMILIA',NULL,NULL,NULL),
	(238,'SALAMANCA',NULL,NULL,NULL),
	(239,'SAN ANTONIO',NULL,NULL,NULL),
	(240,'SAN CARLOS',NULL,NULL,NULL),
	(241,'SAN CLEMENTE',NULL,NULL,NULL),
	(242,'SAN ESTEBAN',NULL,NULL,NULL),
	(243,'SAN FABIAN',NULL,NULL,NULL),
	(244,'SAN FELIPE',NULL,NULL,NULL),
	(245,'SAN FERNANDO',NULL,NULL,NULL),
	(246,'SAN IGNACIO',NULL,NULL,NULL),
	(247,'SAN JAVIER',NULL,NULL,NULL),
	(248,'SAN NICOLAS',NULL,NULL,NULL),
	(249,'SAN PABLO',NULL,NULL,NULL),
	(250,'SAN PEDRO',NULL,NULL,NULL),
	(251,'SAN ROSENDO',NULL,NULL,NULL),
	(252,'SAN VICENTE',NULL,NULL,NULL),
	(253,'SANTA CRUZ',NULL,NULL,NULL),
	(254,'SANTIAGO',NULL,NULL,NULL),
	(255,'SN.BERNARDO',NULL,NULL,NULL),
	(256,'SN.FCO.MOSTAZAL',NULL,NULL,NULL),
	(257,'SN.JOSE DE MAIPO',NULL,NULL,NULL),
	(258,'STA. MARIA',NULL,NULL,NULL),
	(259,'STA.BARBARA',NULL,NULL,NULL),
	(260,'STA.JUANA',NULL,NULL,NULL),
	(261,'STO.DOMINGO',NULL,NULL,NULL),
	(262,'T. AMARILLA',NULL,NULL,NULL),
	(263,'T. DEL PAINE',NULL,NULL,NULL),
	(264,'T.SCHMIDT',NULL,NULL,NULL),
	(265,'TALAGANTE',NULL,NULL,NULL),
	(266,'TALCA',NULL,NULL,NULL),
	(267,'TALCAHUANO',NULL,NULL,NULL),
	(268,'TALTAL',NULL,NULL,NULL),
	(269,'TEMUCO',NULL,NULL,NULL),
	(270,'TENO',NULL,NULL,NULL),
	(271,'TILTIL',NULL,NULL,NULL),
	(272,'TIMAUKEL',NULL,NULL,NULL),
	(273,'TIRUA',NULL,NULL,NULL),
	(274,'TOCOPILLA',NULL,NULL,NULL),
	(275,'TOME',NULL,NULL,NULL),
	(276,'TORTEL',NULL,NULL,NULL),
	(277,'TRAIGUEN',NULL,NULL,NULL),
	(278,'TREGUACO',NULL,NULL,NULL),
	(279,'TUCAPEL',NULL,NULL,NULL),
	(280,'V. ALEMANA',NULL,NULL,NULL),
	(281,'V. DEL MAR',NULL,NULL,NULL),
	(282,'V. OHIGGINS',NULL,NULL,NULL),
	(283,'V. TEHUELCHES',NULL,NULL,NULL),
	(284,'V.ALEGRE',NULL,NULL,NULL),
	(285,'VALDIVIA',NULL,NULL,NULL),
	(286,'VALLENAR',NULL,NULL,NULL),
	(287,'VALPARAISO',NULL,NULL,NULL),
	(288,'VICHUQUEN',NULL,NULL,NULL),
	(289,'VICTORIA',NULL,NULL,NULL),
	(290,'VICUA',NULL,NULL,NULL),
	(291,'VILCUN',NULL,NULL,NULL),
	(292,'VILLARRICA',NULL,NULL,NULL),
	(293,'VISVIRI',NULL,NULL,NULL),
	(294,'YERBAS BUENAS',NULL,NULL,NULL),
	(295,'YUMBEL',NULL,NULL,NULL),
	(296,'YUNGAY',NULL,NULL,NULL),
	(297,'ZAPALLAR',NULL,NULL,NULL),
	(298,'CIUDAD','administrador','2006-07-06','18:31:57'),
	(299,'A-NO DEFINIDA','usuario','2006-07-08','18:14:38'),
	(300,'PUNTA ARENAS','joseantonio','2006-07-27','09:37:12'),
	(301,'LINDEROS','veronica','2006-11-15','12:07:37'),
	(302,'SERENA','veronica','2007-04-03','05:37:35');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_ciudad` ENABLE KEYS*/;


#
# Table structure for table 'la_correlativo'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_correlativo` (
  `id_pnc` int(10) default NULL,
  `id_emp` int(10) default NULL,
  `id_sc` int(10) default NULL,
  `id_oc` int(10) default NULL,
  `id_dv` int(10) default NULL,
  `id_dev` int(10) default NULL,
  `id_ab` int(10) default NULL,
  `id_chl` int(10) default NULL,
  `id_ocp` int(10) default NULL,
  `id_rp` int(10) default NULL,
  `id_rech` int(11) default NULL,
  `id_csc` int(10) default NULL,
  `id_strasp` int(10) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_correlativo'
#

/*!40000 ALTER TABLE `la_correlativo` DISABLE KEYS*/;
LOCK TABLES `la_correlativo` WRITE;
REPLACE INTO `la_correlativo` (`id_pnc`, `id_emp`, `id_sc`, `id_oc`, `id_dv`, `id_dev`, `id_ab`, `id_chl`, `id_ocp`, `id_rp`, `id_rech`, `id_csc`, `id_strasp`) VALUES (500,500,625,500,500,500,500,500,862,762,579,732,525);
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_correlativo` ENABLE KEYS*/;


#
# Table structure for table 'la_csc'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_csc` (
  `id_csc` int(10) NOT NULL,
  `id_ocp` int(11) NOT NULL default '0',
  `fecha_csc` date NOT NULL default '0000-00-00',
  `USER` varchar(30) NOT NULL,
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id_csc`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_csc'
#

/*!40000 ALTER TABLE `la_csc` DISABLE KEYS*/;
LOCK TABLES `la_csc` WRITE;
REPLACE INTO `la_csc` (`id_csc`, `id_ocp`, `fecha_csc`, `USER`, `FECHA_U`, `HORA`) VALUES (100,0,'0000-00-00','','0000-00-00','00:00:00'),
	(729,0,'2007-10-11','','2007-10-11','00:00:00'),
	(730,0,'2007-10-11','','2007-10-11','00:00:00'),
	(731,854,'2007-10-11','','2007-10-11','00:00:00');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_csc` ENABLE KEYS*/;


#
# Table structure for table 'la_csc_det'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_csc_det` (
  `id_csc` int(11) NOT NULL,
  `COD_MP` int(10) NOT NULL,
  `cantidad` int(11) NOT NULL,
  `val_unit` int(11) NOT NULL,
  PRIMARY KEY  (`id_csc`,`COD_MP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_csc_det'
#

/*!40000 ALTER TABLE `la_csc_det` DISABLE KEYS*/;
LOCK TABLES `la_csc_det` WRITE;
REPLACE INTO `la_csc_det` (`id_csc`, `COD_MP`, `cantidad`, `val_unit`) VALUES (100,2,2,1),
	(730,6,6,6),
	(731,6,6,6),
	(731,3,6,3),
	(731,2,6,2),
	(731,5,6,5);
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_csc_det` ENABLE KEYS*/;


#
# Table structure for table 'la_cuentas_contables'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_cuentas_contables` (
  `codigo_cc` varchar(10) NOT NULL default '',
  `descripcion_cc` varchar(50) default NULL,
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`codigo_cc`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_cuentas_contables'
#

/*!40000 ALTER TABLE `la_cuentas_contables` DISABLE KEYS*/;
LOCK TABLES `la_cuentas_contables` WRITE;
REPLACE INTO `la_cuentas_contables` (`codigo_cc`, `descripcion_cc`, `USER`, `FECHA_U`, `HORA`) VALUES ('111223423','PAGO PROVEEDORES','administrador','2006-12-04','13:50:14');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_cuentas_contables` ENABLE KEYS*/;


#
# Table structure for table 'la_idpago'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_idpago` (
  `ID_PAGO` bigint(20) default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_idpago'
#

/*!40000 ALTER TABLE `la_idpago` DISABLE KEYS*/;
LOCK TABLES `la_idpago` WRITE;
REPLACE INTO `la_idpago` (`ID_PAGO`) VALUES ('260402'),
	('260402'),
	('260402');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_idpago` ENABLE KEYS*/;


#
# Table structure for table 'la_mat_por_bod'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_mat_por_bod` (
  `COD_MP` varchar(12) NOT NULL,
  `codigo_bo` char(3) NOT NULL,
  `STOCKCRIT` int(11) NOT NULL,
  `stock_hab` int(11) NOT NULL,
  `stock_bloq` int(11) NOT NULL,
  `lote` int(2) NOT NULL,
  `control_cal` int(2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_mat_por_bod'
#

/*!40000 ALTER TABLE `la_mat_por_bod` DISABLE KEYS*/;
LOCK TABLES `la_mat_por_bod` WRITE;
REPLACE INTO `la_mat_por_bod` (`COD_MP`, `codigo_bo`, `STOCKCRIT`, `stock_hab`, `stock_bloq`, `lote`, `control_cal`) VALUES ('5','BI',6,1,1,1,1),
	('3','OF',10,5,5,0,0),
	('4','BP',12,6,6,1,0),
	('2','BP',22,0,0,0,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_mat_por_bod` ENABLE KEYS*/;


#
# Table structure for table 'la_mat_por_provee'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_mat_por_provee` (
  `COD_MP` varchar(12) NOT NULL,
  `RUT_PRO` int(8) NOT NULL,
  `VAL_ULTC` int(11) NOT NULL,
  `f_conv` int(11) NOT NULL,
  `COD_UNI` varchar(4) NOT NULL,
  `FECH_ULTM` date NOT NULL default '0000-00-00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_mat_por_provee'
#

/*!40000 ALTER TABLE `la_mat_por_provee` DISABLE KEYS*/;
LOCK TABLES `la_mat_por_provee` WRITE;
REPLACE INTO `la_mat_por_provee` (`COD_MP`, `RUT_PRO`, `VAL_ULTC`, `f_conv`, `COD_UNI`, `FECH_ULTM`) VALUES ('3',1,3,0,'GR','0000-00-00'),
	('6',2,2,0,'BD','0000-00-00'),
	('5',2,5,0,'BL','0000-00-00'),
	('2',2,2335,0,'KG','0000-00-00'),
	('4',2,2,0,'BD','0000-00-00'),
	('4',1,2,0,'BD','0000-00-00');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_mat_por_provee` ENABLE KEYS*/;


#
# Table structure for table 'la_matprima'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_matprima` (
  `ID_MP` bigint(7) NOT NULL auto_increment,
  `COD_MP` varchar(12) NOT NULL,
  `DESC_MP` varchar(50) NOT NULL,
  `id_tpp` varchar(5) NOT NULL default '',
  `COSTMED_MP` float NOT NULL default '0',
  `COD_UNI` varchar(4) NOT NULL,
  `f_c` bigint(11) NOT NULL,
  `unid_min` int(11) NOT NULL,
  `INVENT` varchar(18) NOT NULL,
  `prod_serv` varchar(15) NOT NULL,
  `codigo_cc` bigint(11) NOT NULL,
  `fech_ultm` date NOT NULL,
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`ID_MP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_matprima'
#

/*!40000 ALTER TABLE `la_matprima` DISABLE KEYS*/;
LOCK TABLES `la_matprima` WRITE;
REPLACE INTO `la_matprima` (`ID_MP`, `COD_MP`, `DESC_MP`, `id_tpp`, `COSTMED_MP`, `COD_UNI`, `f_c`, `unid_min`, `INVENT`, `prod_serv`, `codigo_cc`, `fech_ultm`, `USER`, `FECHA_U`, `HORA`) VALUES ('69','2','dos','1','0','KG','1',1,'1','producto','111223423','0000-00-00','','2007-09-24','09:26:54'),
	('70','3','tres','1','0','KG','8',1,'inventariable','producto','111223423','0000-00-00','','2007-10-18','11:16:29'),
	('71','4','cuatro','1','0','GR','3',3,'1','servicio','111223423','0000-00-00','','2007-09-25','10:54:40'),
	('72','5','cinco','1','0','GR','5',5,'','producto','111223423','0000-00-00','','2007-09-25','10:54:55'),
	('73','6','seis','1','0','GR','6',6,'','servicio','111223423','0000-00-00','','2007-09-25','10:55:05'),
	('74','7','siete','1','0','KG','7',7,'1','producto','111223423','0000-00-00','','2007-09-25','10:55:19');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_matprima` ENABLE KEYS*/;


#
# Table structure for table 'la_moneda'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_moneda` (
  `cod_mone` int(11) NOT NULL,
  `desc_mone` varchar(50) NOT NULL,
  PRIMARY KEY  (`cod_mone`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_moneda'
#

/*!40000 ALTER TABLE `la_moneda` DISABLE KEYS*/;
LOCK TABLES `la_moneda` WRITE;
REPLACE INTO `la_moneda` (`cod_mone`, `desc_mone`) VALUES (1,'Peso'),
	(2,'Dolar');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_moneda` ENABLE KEYS*/;


#
# Table structure for table 'la_orden_com_det'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_orden_com_det` (
  `id_ocp_det` int(10) NOT NULL auto_increment,
  `id_ocp` int(10) NOT NULL default '0',
  `COD_MP` varchar(10) NOT NULL default '',
  `unitario` float default NULL,
  `cantidad` float default NULL,
  `cant_recepc` int(11) NOT NULL,
  `vtotal` float default NULL,
  `fecha_ent` date NOT NULL default '0000-00-00',
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id_ocp_det`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_orden_com_det'
#

/*!40000 ALTER TABLE `la_orden_com_det` DISABLE KEYS*/;
LOCK TABLES `la_orden_com_det` WRITE;
REPLACE INTO `la_orden_com_det` (`id_ocp_det`, `id_ocp`, `COD_MP`, `unitario`, `cantidad`, `cant_recepc`, `vtotal`, `fecha_ent`, `USER`, `FECHA_U`, `HORA`) VALUES (1,794,'5','3','3',3,'3','0000-00-00','','0000-00-00','00:00:03'),
	(42,842,'2','11','1',0,'11','2007-10-11','','2007-10-11','09:02:56'),
	(43,842,'3','11','1',0,'11','2007-10-11','','2007-10-11','09:03:01'),
	(44,853,'3','3','22',0,'66','2007-10-12','','2007-10-12','16:28:54'),
	(45,854,'3','3','9',0,'27','2007-10-12','','2007-10-12','16:35:06');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_orden_com_det` ENABLE KEYS*/;


#
# Table structure for table 'la_orden_compra'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_orden_compra` (
  `id_ocp` int(10) NOT NULL default '0',
  `fecha_ocp` date NOT NULL default '0000-00-00',
  `fecha_ent` date default '0000-00-00',
  `RUT_TRAB` int(8) NOT NULL,
  `RUT_PRO` int(8) NOT NULL,
  `ID_PAGO` int(10) NOT NULL default '0',
  `moneda` varchar(11) NOT NULL,
  `valor_dolar` float default NULL,
  `nro_solic_com` int(11) NOT NULL,
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id_ocp`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_orden_compra'
#

/*!40000 ALTER TABLE `la_orden_compra` DISABLE KEYS*/;
LOCK TABLES `la_orden_compra` WRITE;
REPLACE INTO `la_orden_compra` (`id_ocp`, `fecha_ocp`, `fecha_ent`, `RUT_TRAB`, `RUT_PRO`, `ID_PAGO`, `moneda`, `valor_dolar`, `nro_solic_com`, `USER`, `FECHA_U`, `HORA`) VALUES (840,'0000-00-00','0000-00-00',1,1,1,'','11',609,'administrador','2007-10-11','08:53:56'),
	(841,'0000-00-00','0000-00-00',1,1,9,'','11',100,'administrador','2007-10-11','08:55:23'),
	(842,'0000-00-00','0000-00-00',1,1,9,'','1',609,'administrador','2007-10-11','09:02:47'),
	(843,'0000-00-00','0000-00-00',1,1,6,'','1',100,'administrador','2007-10-11','09:05:29'),
	(794,'2003-03-03','2006-01-01',1,1,1,'peso','22',609,'','2007-10-09','09:07:00'),
	(844,'0000-00-00','0000-00-00',1,1,10,'','1',100,'administrador','2007-10-11','09:23:39'),
	(845,'0000-00-00','0000-00-00',1,2,10,'','2',100,'administrador','2007-10-11','09:24:21'),
	(846,'0000-00-00','0000-00-00',1,1,6,'','11',100,'administrador','2007-10-11','09:25:02'),
	(847,'0000-00-00','0000-00-00',1,2,9,'','2',609,'administrador','2007-10-11','09:37:32'),
	(848,'0000-00-00','0000-00-00',1,2,8,'','2',609,'administrador','2007-10-11','09:37:56'),
	(853,'0000-00-00','0000-00-00',1,1,6,'','2',731,'administrador','2007-10-12','16:28:40'),
	(854,'0000-00-00','0000-00-00',1,1,10,'','1',731,'administrador','2007-10-12','16:34:47');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_orden_compra` ENABLE KEYS*/;


#
# Table structure for table 'la_personal'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_personal` (
  `RUT_TRAB` int(8) NOT NULL default '0',
  `DV_TRAB` char(1) NOT NULL default '',
  `APELL_TRAB` varchar(20) NOT NULL default '',
  `NOM_TRAB` varchar(20) NOT NULL default '',
  `DIR_TRAB` varchar(50) NOT NULL default '',
  `CIU_TRAB` int(5) default '0',
  `COM_TRAB` int(5) default '0',
  `TEL_TRAB` varchar(30) default NULL,
  `CEL_TRAB` varchar(20) default NULL,
  `id_cp` varchar(9) NOT NULL default '',
  `id_fp` varchar(9) NOT NULL default '',
  `id_ut` varchar(9) NOT NULL default '',
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_personal'
#

/*!40000 ALTER TABLE `la_personal` DISABLE KEYS*/;
LOCK TABLES `la_personal` WRITE;
REPLACE INTO `la_personal` (`RUT_TRAB`, `DV_TRAB`, `APELL_TRAB`, `NOM_TRAB`, `DIR_TRAB`, `CIU_TRAB`, `COM_TRAB`, `TEL_TRAB`, `CEL_TRAB`, `id_cp`, `id_fp`, `id_ut`, `USER`, `FECHA_U`, `HORA`) VALUES (1,'9','GROFF','MARCELO','A',1,1,'321321','123456','1','1','1','1','0000-00-00','00:00:01');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_personal` ENABLE KEYS*/;


#
# Table structure for table 'la_prod_bod'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_prod_bod` (
  `COD_PROD` varchar(12) NOT NULL,
  `codigo_bo` char(3) NOT NULL,
  `STOCKCRIT` int(11) NOT NULL,
  `stock_hab` int(11) NOT NULL,
  `stock_bloq` int(11) NOT NULL,
  `FAC_PROD` int(11) NOT NULL,
  `lote` int(11) NOT NULL,
  `control_cal` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_prod_bod'
#

/*!40000 ALTER TABLE `la_prod_bod` DISABLE KEYS*/;
LOCK TABLES `la_prod_bod` WRITE;
REPLACE INTO `la_prod_bod` (`COD_PROD`, `codigo_bo`, `STOCKCRIT`, `stock_hab`, `stock_bloq`, `FAC_PROD`, `lote`, `control_cal`) VALUES ('104','OF',11,111,11,0,1,1),
	('103','BP',1,1,1,0,1,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_prod_bod` ENABLE KEYS*/;


#
# Table structure for table 'la_prod_provee'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_prod_provee` (
  `COD_PROD` varchar(12) NOT NULL,
  `RUT_PRO` int(8) NOT NULL,
  `DV_PRO` char(1) default NULL,
  `VAL_ULTC` int(11) NOT NULL,
  `UN_PROD` varchar(4) NOT NULL,
  `FECH_ULTM` date NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_prod_provee'
#

/*!40000 ALTER TABLE `la_prod_provee` DISABLE KEYS*/;
LOCK TABLES `la_prod_provee` WRITE;
REPLACE INTO `la_prod_provee` (`COD_PROD`, `RUT_PRO`, `DV_PRO`, `VAL_ULTC`, `UN_PROD`, `FECH_ULTM`) VALUES ('3133',2,'',100,'PT','0000-00-00');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_prod_provee` ENABLE KEYS*/;


#
# Table structure for table 'la_producto'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_producto` (
  `COD_CLA` char(2) NOT NULL default '0',
  `COD_PROD` varchar(12) NOT NULL default '0',
  `DESC_PROD` varchar(50) default NULL,
  `UN_PROD` varchar(4) default NULL,
  `id_tpe` varchar(5) NOT NULL,
  `UNDET_PROD` varchar(4) default NULL,
  `COSTO_PROD` float default NULL,
  `PREC_LIS` int(11) NOT NULL default '0',
  `INVENT` varchar(15) NOT NULL,
  `prod_serv` varchar(10) NOT NULL,
  `codigo_cc` varchar(10) NOT NULL,
  `FECH_ULTM` date NOT NULL,
  `USER` varchar(30) default NULL,
  `FECHA_U` date default NULL,
  `HORA` time default NULL,
  PRIMARY KEY  (`COD_CLA`,`COD_PROD`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_producto'
#

/*!40000 ALTER TABLE `la_producto` DISABLE KEYS*/;
LOCK TABLES `la_producto` WRITE;
REPLACE INTO `la_producto` (`COD_CLA`, `COD_PROD`, `DESC_PROD`, `UN_PROD`, `id_tpe`, `UNDET_PROD`, `COSTO_PROD`, `PREC_LIS`, `INVENT`, `prod_serv`, `codigo_cc`, `FECH_ULTM`, `USER`, `FECHA_U`, `HORA`) VALUES ('0','101','ciento-uno','BD','1','1','1',0,'inventariable','servicio','111223423','1999-03-09','','2007-09-11','14:33:52'),
	('0','102','ciento-dos','KG','1','1','1',0,'','','111223423','1999-03-09','','2007-09-13','16:42:49'),
	('0','103','ciento-tres','BD','1','1','1',0,'','','111223423','1999-03-09','','2007-09-11','14:51:54'),
	('0','104','ciento-cuatro','LT','1','321','13',0,'','servicio','111223423','0000-00-00','','2007-09-13','16:41:32'),
	('0','108','ciento-ocho','GR','1','2','0',0,'inventariable','producto','111223423','0000-00-00','','2007-10-18','12:18:20');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_producto` ENABLE KEYS*/;


#
# Table structure for table 'la_proveedor'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_proveedor` (
  `RUT_PRO` int(8) NOT NULL default '0',
  `DV_PRO` char(1) NOT NULL default '',
  `RAZON_SOC` varchar(50) NOT NULL default '',
  `DIR_PRO` varchar(50) NOT NULL default '',
  `CIU_PRO` int(5) NOT NULL default '0',
  `COM_PRO` int(5) NOT NULL default '0',
  `CONTACTO_PRO` varchar(50) NOT NULL default '',
  `TEL_PRO` varchar(30) NOT NULL default '',
  `CEL_PRO` varchar(20) NOT NULL default '',
  `EMAIL_PRO` varchar(100) NOT NULL default '',
  `GIRO_PRO` int(11) NOT NULL default '0',
  `id_ep` varchar(9) NOT NULL default '',
  `TIPO_PAGO` int(11) NOT NULL default '0',
  `id_cap` varchar(5) NOT NULL default '',
  `ADEU_PRO` double NOT NULL default '0',
  `CERTIFCAL` varchar(20) NOT NULL default '',
  `USER` varchar(20) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_proveedor'
#

/*!40000 ALTER TABLE `la_proveedor` DISABLE KEYS*/;
LOCK TABLES `la_proveedor` WRITE;
REPLACE INTO `la_proveedor` (`RUT_PRO`, `DV_PRO`, `RAZON_SOC`, `DIR_PRO`, `CIU_PRO`, `COM_PRO`, `CONTACTO_PRO`, `TEL_PRO`, `CEL_PRO`, `EMAIL_PRO`, `GIRO_PRO`, `id_ep`, `TIPO_PAGO`, `id_cap`, `ADEU_PRO`, `CERTIFCAL`, `USER`, `FECHA_U`, `HORA`) VALUES (2,'7','PRIMER PROVEEDOR','LOS LEONS',11,309,'321','3333','124','UUU@UU',26,'1',4,'1','12','1','administrador','2007-10-02','12:21:53'),
	(1,'9','SEGUNDO PROVEEDOR','LOS LEONES',11,309,'321','123','3333','PP@PP',26,'1',4,'1','100','1','administrador','2007-09-07','10:15:24');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_proveedor` ENABLE KEYS*/;


#
# Table structure for table 'la_rec_prov'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_rec_prov` (
  `id_rp` int(10) NOT NULL default '0',
  `id_ocp` int(10) NOT NULL default '0',
  `fecha_rp` date NOT NULL default '0000-00-00',
  `codigo_bo` char(3) NOT NULL default '',
  `nro_guia` int(10) NOT NULL default '0',
  `fecha_guia` date NOT NULL default '0000-00-00',
  `tipoguia` varchar(10) NOT NULL default '',
  `nro_factura` int(10) NOT NULL default '0',
  `fecha_factura` date NOT NULL default '0000-00-00',
  `fec_venc_fac` date NOT NULL default '0000-00-00',
  `tipofactura` varchar(10) NOT NULL default '',
  `neto` float default NULL,
  `iva` float default NULL,
  `total` float default NULL,
  `exenta` float default NULL,
  `codigo_cc` varchar(10) NOT NULL default '',
  `mes` varchar(20) NOT NULL default '',
  `observ` varchar(250) NOT NULL default '',
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_rec_prov'
#

/*!40000 ALTER TABLE `la_rec_prov` DISABLE KEYS*/;
LOCK TABLES `la_rec_prov` WRITE;
REPLACE INTO `la_rec_prov` (`id_rp`, `id_ocp`, `fecha_rp`, `codigo_bo`, `nro_guia`, `fecha_guia`, `tipoguia`, `nro_factura`, `fecha_factura`, `fec_venc_fac`, `tipofactura`, `neto`, `iva`, `total`, `exenta`, `codigo_cc`, `mes`, `observ`, `USER`, `FECHA_U`, `HORA`) VALUES (759,794,'2007-10-17','BI',11,'0000-00-00','Normal',11,'0000-00-00','0000-00-00','Normal','11','11','11','0','111223423','marzo','','','2007-10-17','13:18:41');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_rec_prov` ENABLE KEYS*/;


#
# Table structure for table 'la_rech_prov'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_rech_prov` (
  `id_rech` int(11) NOT NULL,
  `id_rp` int(11) NOT NULL,
  `fech_rech` date default '0000-00-00',
  `observ` varchar(50) NOT NULL,
  `USER` varchar(50) default NULL,
  `FECHA_U` date default '0000-00-00',
  `HORA` time default '00:00:00',
  PRIMARY KEY  (`id_rech`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_rech_prov'
#

/*!40000 ALTER TABLE `la_rech_prov` DISABLE KEYS*/;
LOCK TABLES `la_rech_prov` WRITE;
REPLACE INTO `la_rech_prov` (`id_rech`, `id_rp`, `fech_rech`, `observ`, `USER`, `FECHA_U`, `HORA`) VALUES (563,759,'2007-10-17','','','2007-10-17','00:00:00'),
	(565,794,'2007-10-17','','','2007-10-17','00:00:00'),
	(566,759,'2007-10-17','','','2007-10-17','00:00:00'),
	(571,794,'2007-10-17','','','2007-10-17','00:00:00'),
	(572,759,'2007-10-17','','','2007-10-17','00:00:00'),
	(573,759,'2007-10-17','','','2007-10-17','00:00:00'),
	(574,759,'2007-10-17','','','2007-10-17','00:00:00'),
	(576,759,'2007-10-18','','','2007-10-18','00:00:00'),
	(0,0,'0000-00-00','','','2007-10-18','00:00:00'),
	(577,2,'2007-10-18','','','2007-10-18','00:00:00'),
	(578,759,'2007-10-18','','','2007-10-18','00:00:00'),
	(562,759,'2007-10-17','','','2007-10-17','00:00:00');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_rech_prov` ENABLE KEYS*/;


#
# Table structure for table 'la_rechprov_det'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_rechprov_det` (
  `id_rech_det` int(11) NOT NULL,
  `id_rech` int(11) NOT NULL,
  `COD_MP` int(11) NOT NULL,
  `CANT_RECEP` int(11) NOT NULL,
  `CANT_RECH` int(11) NOT NULL,
  `v_total` int(11) NOT NULL,
  `LOTE` int(11) NOT NULL,
  `USER` varchar(50) NOT NULL,
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id_rech`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_rechprov_det'
#

/*!40000 ALTER TABLE `la_rechprov_det` DISABLE KEYS*/;
LOCK TABLES `la_rechprov_det` WRITE;
REPLACE INTO `la_rechprov_det` (`id_rech_det`, `id_rech`, `COD_MP`, `CANT_RECEP`, `CANT_RECH`, `v_total`, `LOTE`, `USER`, `FECHA_U`, `HORA`) VALUES (0,566,5,666,22255,0,121,'','2007-10-17','14:26:45'),
	(0,573,5,1122,22222,0,121,'','2007-10-17','16:00:05'),
	(0,574,5,1122,22222,0,121,'','2007-10-17','16:27:45'),
	(0,576,5,1122,22222,0,121,'','2007-10-18','08:45:14');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_rechprov_det` ENABLE KEYS*/;


#
# Table structure for table 'la_recp_det'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_recp_det` (
  `id_rp` int(10) NOT NULL,
  `COD_MP` varchar(12) NOT NULL,
  `unitario` float NOT NULL,
  `cant_ord` int(11) NOT NULL,
  `cant_recep` float NOT NULL,
  `vtotal` int(11) NOT NULL,
  `lote` int(11) NOT NULL,
  `fech_lote` date default '0000-00-00',
  `USER` varchar(50) NOT NULL,
  `FECHA_U` date default '0000-00-00',
  `HORA` time default '00:00:00',
  PRIMARY KEY  (`id_rp`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_recp_det'
#

/*!40000 ALTER TABLE `la_recp_det` DISABLE KEYS*/;
LOCK TABLES `la_recp_det` WRITE;
REPLACE INTO `la_recp_det` (`id_rp`, `COD_MP`, `unitario`, `cant_ord`, `cant_recep`, `vtotal`, `lote`, `fech_lote`, `USER`, `FECHA_U`, `HORA`) VALUES (759,'5','3',3,'11',33,11,'2007-10-17','','2007-10-17','13:21:07');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_recp_det` ENABLE KEYS*/;


#
# Table structure for table 'la_sc'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_sc` (
  `id_sc` int(10) NOT NULL default '0',
  `fecha_sc` date NOT NULL default '0000-00-00',
  `id_area` int(10) NOT NULL default '0',
  `RUT_TRAB` int(8) NOT NULL default '0',
  `consol` int(2) NOT NULL default '0',
  `anulado` int(2) NOT NULL default '0',
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id_sc`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_sc'
#

/*!40000 ALTER TABLE `la_sc` DISABLE KEYS*/;
LOCK TABLES `la_sc` WRITE;
REPLACE INTO `la_sc` (`id_sc`, `fecha_sc`, `id_area`, `RUT_TRAB`, `consol`, `anulado`, `USER`, `FECHA_U`, `HORA`) VALUES (609,'2007-09-27',1,1,731,0,'administrador','2007-09-27','17:07:31');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_sc` ENABLE KEYS*/;


#
# Table structure for table 'la_sc_det'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_sc_det` (
  `id_sc_det` int(10) NOT NULL auto_increment,
  `id_sc` int(10) NOT NULL default '0',
  `COD_MP` varchar(20) NOT NULL default '',
  `cant_sc` int(10) NOT NULL default '0',
  `val_unit` int(10) NOT NULL default '0',
  `solic_p` varchar(10) NOT NULL,
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id_sc_det`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_sc_det'
#

/*!40000 ALTER TABLE `la_sc_det` DISABLE KEYS*/;
LOCK TABLES `la_sc_det` WRITE;
REPLACE INTO `la_sc_det` (`id_sc_det`, `id_sc`, `COD_MP`, `cant_sc`, `val_unit`, `solic_p`, `USER`, `FECHA_U`, `HORA`) VALUES (47,609,'6',6,6,'6','administrador','2007-09-27','17:08:37'),
	(48,609,'3',6,3,'6','administrador','2007-09-27','17:08:39'),
	(49,609,'2',6,2,'6','administrador','2007-09-27','17:08:43'),
	(50,609,'5',6,5,'6','administrador','2007-09-27','17:08:45');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_sc_det` ENABLE KEYS*/;


#
# Table structure for table 'la_solic_trasp'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_solic_trasp` (
  `id_strasp` int(10) NOT NULL,
  `fech_strasp` date default '0000-00-00',
  `bod_solic` varchar(10) NOT NULL,
  `bod_desp` varchar(10) NOT NULL,
  `solic_por` varchar(50) NOT NULL,
  `USER` varchar(50) default NULL,
  `FECH_U` date default '0000-00-00',
  `HORA` time default '00:00:00',
  PRIMARY KEY  (`id_strasp`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_solic_trasp'
#

/*!40000 ALTER TABLE `la_solic_trasp` DISABLE KEYS*/;
LOCK TABLES `la_solic_trasp` WRITE;
REPLACE INTO `la_solic_trasp` (`id_strasp`, `fech_strasp`, `bod_solic`, `bod_desp`, `solic_por`, `USER`, `FECH_U`, `HORA`) VALUES (521,'2007-10-18','BI','BP','2','','2007-10-18','10:49:26'),
	(519,'2007-10-18','','','','','2007-10-18','10:22:44'),
	(520,'2007-10-18','BP','BI','1','','2007-10-18','10:23:16'),
	(523,'2007-10-18','BP','BI','1','','2007-10-18','11:06:02'),
	(524,'2007-10-18','BI','BI','1','','2007-10-18','11:06:15');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_solic_trasp` ENABLE KEYS*/;


#
# Table structure for table 'la_strasp_det'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_strasp_det` (
  `id_strasp` int(10) NOT NULL default '0',
  `COD_MP` varchar(12) default NULL,
  `cantidad_st` int(11) NOT NULL,
  `p_stock` int(11) NOT NULL,
  `USER` varchar(50) NOT NULL,
  `FECH_U` date default '0000-00-00',
  `HORA` time default '00:00:00',
  PRIMARY KEY  (`id_strasp`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_strasp_det'
#

/*!40000 ALTER TABLE `la_strasp_det` DISABLE KEYS*/;
LOCK TABLES `la_strasp_det` WRITE;
REPLACE INTO `la_strasp_det` (`id_strasp`, `COD_MP`, `cantidad_st`, `p_stock`, `USER`, `FECH_U`, `HORA`) VALUES (521,'2',2,2,'','2007-10-18','10:49:54'),
	(524,'2',1,1,'','2007-10-18','11:06:41');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_strasp_det` ENABLE KEYS*/;


#
# Table structure for table 'la_tipo_produc_elabo'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_tipo_produc_elabo` (
  `id_tpe` bigint(5) NOT NULL auto_increment,
  `descripcion_tpe` varchar(50) default NULL,
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id_tpe`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_tipo_produc_elabo'
#

/*!40000 ALTER TABLE `la_tipo_produc_elabo` DISABLE KEYS*/;
LOCK TABLES `la_tipo_produc_elabo` WRITE;
REPLACE INTO `la_tipo_produc_elabo` (`id_tpe`, `descripcion_tpe`, `USER`, `FECHA_U`, `HORA`) VALUES ('1','LIQUIDO','administrador','2007-10-11','09:50:19'),
	('2','SOLIDO','','2007-10-11','09:50:27');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_tipo_produc_elabo` ENABLE KEYS*/;


#
# Table structure for table 'la_tipo_produc_provee'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_tipo_produc_provee` (
  `id_tpp` bigint(5) NOT NULL auto_increment,
  `descripcion_tpp` varchar(50) default NULL,
  `USER` varchar(30) NOT NULL default '',
  `FECHA_U` date NOT NULL default '0000-00-00',
  `HORA` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id_tpp`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_tipo_produc_provee'
#

/*!40000 ALTER TABLE `la_tipo_produc_provee` DISABLE KEYS*/;
LOCK TABLES `la_tipo_produc_provee` WRITE;
REPLACE INTO `la_tipo_produc_provee` (`id_tpp`, `descripcion_tpp`, `USER`, `FECHA_U`, `HORA`) VALUES ('1','TIPO Uno','administrador','2006-12-04','08:31:51');
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_tipo_produc_provee` ENABLE KEYS*/;


#
# Table structure for table 'la_unidad'
#

CREATE TABLE /*!32312 IF NOT EXISTS*/ `la_unidad` (
  `id` bigint(20) NOT NULL auto_increment,
  `COD_UNI` varchar(4) NOT NULL default '',
  `DESC_UNI` varchar(30) default NULL,
  `USER` varchar(30) default NULL,
  `FECHA_U` date default NULL,
  `HORA` time default NULL,
  PRIMARY KEY  (`id`,`COD_UNI`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



#
# Dumping data for table 'la_unidad'
#

/*!40000 ALTER TABLE `la_unidad` DISABLE KEYS*/;
LOCK TABLES `la_unidad` WRITE;
REPLACE INTO `la_unidad` (`id`, `COD_UNI`, `DESC_UNI`, `USER`, `FECHA_U`, `HORA`) VALUES ('1','KG','KILOGRAMO','administrador','2006-07-07','06:38:12'),
	('2','GR','GRAMOS','administrador','2006-07-07','06:38:17'),
	('3','BD','BALDE',NULL,NULL,NULL),
	('10','BL','BOLSA','administrador','2006-07-24','00:23:53'),
	('11','PT','POTE','administrador','2006-07-24','00:33:20'),
	('12','LT','LITRO','usuario','2006-07-25','11:42:50'),
	('13','ML','MILILITROS','usuario','2006-07-25','11:43:38'),
	('14','UN','UNIDAD','marcelo','2007-04-27',NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `la_unidad` ENABLE KEYS*/;
